---
title: "Admin guide"
linkTitle: "Admin guide"
weight: 99
---

_Please note this guide is a work in progress. Thank you for your patience!_

## Account Admin

The admin team for the [We Are R-Ladies Bluesky account](https://bsky.app/profile/weare.rladies.org) is made up of members of the R-Ladies community. The team usually consists of 1 to 4 people, with responsibilities rotating on a monthly basis. Being an admin is a fantastic opportunity to connect with R-Ladies from around the world while facilitating an online community resource.

## Primary Responsibilities

The responsibilities of the account admin are to:

- Coordinate and grant Bluesky account access to curators

- Provide instructions to curators and answer questions

- Update and expand on rotating curator (RoCur) documentation

- Recruit R-Ladies to be curators for the account

## Recruiting Curators

RoCur admins can recruit potential curators in a variety of ways:

- Messaging the R-Ladies Community Slack

- Reaching out to organizers of different R-Ladies chapters

- Posting a general call via the [R-Ladies](https://bsky.app/profile/rladies.org) or [We Are R-Ladies](https://bsky.app/profile/weare.rladies.org) Bluesky accounts

- Contacting specific individuals

In line with [R-Ladies' mission](https://rladies.org/about-us/mission/), this account aims to spotlight minority genders (including but not limited to cis/trans women, trans men, non-binary individuals) and their great work in R. Featured curators should come from a diversity of professions and have a range of experiences in R, from novice to expert. Currently, we do not have a protocol for individuals to curate more than once.

We also aim for this RoCur account to be a sustainable initiative. Therefore, there is no pressure for RoCur admins to have curators lined up every single week. Additionally, RoCur admins are allowed to identify weeks during the year for the account to go on hiatus (i.e., an extended period with no curators).

## Admin Procedures

_The following emojis will be used throughout this documentation to indicate where specific actions need to be performed:_

- 📊: Airtable

- 📁: Google Drive

- ✉️: Email

- 🦋: Bluesky

-   🅱️: Buffer(optional)

### When someone signs up to curate

1.  📊Add them to the [curator schedule](https://rladies.org/form/rocur-schedule/) as soon as possible, so other potential curators are aware the week is unavailable.

2.  📁Save the photo they attached to their Airtable form in the [shared Google Drive folder](https://drive.google.com/drive/folders/1XHSFOHHVvXny3ktGOcGVBXsUXeOYD_Qr?usp=sharing).

    - Save the file as **YYYY-MM-DD-firstname**, using the first day of the scheduled curation week as the date.

3.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that their photo has been saved.

4.  ✉️Email the curator confirming their curation week. If the curator did not attach a photo to their Airtable form, you can also ask them to email to you. You can use the following template:

> **_Subject: Your opportunity to curate for the We Are R-Ladies Bluesky account_**
>
> _Hi [curator's name],_
>
> _Your curation is scheduled to begin on [start date of curation]. We'll contact you 1 week before your curation with more details. Let us know if you have any questions!_
>
> _Thank you,_
>
> _Rotating Curation (RoCur) admins_

4.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that Email 1 (notice of curation week) has been sent.

### When someone is nominated to curate

1.  The Airtable app has been set up to automatically notify the nominee via email upon nomination. If it's necessary to manually notify the nominee, use the template below:

> **\*Subject: Invitation to become a curator on the We Are R-Ladies Bluesky account**\
> \
> Hi [potential curator's name],\
> \
> I hope this message finds you well!\
> \
> My name is [your name], and I'm an admin for the [We Are R-Ladies Rotating Curation (RoCur) account on Bluesky](https://bsky.app/profile/weare.rladies.org).\*
>
> _For a bit of context, RoCur is a program where we feature a new curator every week from the R community. The curator takes over our account to share their insights, interests, and work._
>
> _I'm reaching out because you were nominated by [nominator's name] to be a curator for the We Are R-Ladies Bluesky account. They believe you would make a fantastic curator because [reason provided in nomination form]._
>
> _If you're interested in joining us, please fill out [this form](https://rladies.org/form/rocur-signup/)._
>
> _For more details about the RoCur program, feel free to check out [our webpage](https://guide.rladies.org/rocur/about/)._
>
> _If you have any questions or would like to learn more, don't hesitate to reply to this email._
>
> _Thank you for your time and cooperation!_
>
> _RoCur admins_

2.  Once they have filled out the [curator sign-up form](https://rladies.org/form/rocur-signup/), follow the steps outlined in [When someone signs up to curate]_._
3.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that the nominee has been contacted.

### 1 week before they are scheduled to curate

1.  📁Create a draft of their introduction graphic using the information they provided in the Airtable form.
    1.  The template and previously created graphics are available in the [shared Google Drive folder](https://drive.google.com/drive/folders/1XHSFOHHVvXny3ktGOcGVBXsUXeOYD_Qr?usp=sharing).
2.  ✉️Using the template below, send an email to the curator that includes:
    - A reminder of when they are scheduled to curate;
    - A draft of the graphic, requesting for their approval or feedback for any changes; and
    - A link to the curator guide, asking if they have any questions.

> **_Subject: Request for approval of graphic for We Are R-Ladies Bluesky account_**
>
> _Hi [curator's name],_
>
> _We're delighted to have you curate next week! You are scheduled to curate from **Monday, [start date of curation]** to **Saturday, [end date of curation]**. Depending on your schedule, we can modify this slightly (e.g., start on Tuesday or end on Friday) – just let us know. We appreciate your time and contributions to the We Are R-Ladies Bluesky account!_
>
> _Here's what we ask from you prior to your curation:_
>
> 1.  *We have attached the graphic that we'll post this Sunday to introduce you to our followers. Please let us know if you'd like us to make any changes no later than **this Wednesday**.*
> 2.  *If you'd like to use [Buffer](https://buffer.com/) to help create and schedule your posts during your curation, please let us know no later than **this Wednesday.** We'll send you an invitation to join the We Are R-Ladies Buffer account and give you posting access during your curation. This is completely optional.*
> 3.  *Please read through our [guide for curators](https://guide.rladies.org/rocur/guide/).*
> 4.  *If you haven't already, please add yourself to the [R-Ladies directory](https://rladies.org/directory/).*
>
> _We'll contact you later this week with more details on accessing our Bluesky account. In the meantime, let us know if you have any questions about curating!_
>
> _Thank you,_
>
> _Rotating Curation (RoCur) admins_

3.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that Email 2 (request for approval of graphic) has been sent.

4.  📁If the curator asks for changes to their graphic, update it and send revised drafts until they approve.

5.  📊After the curator approves their graphic, update the admin checklist in the RoCur Curator Sign Up Airtable to reflect this.

6.  🅱️If a curator requests access to Buffer, follow these steps to invite them (adapted from [this Buffer Help Center post](https://support.buffer.com/article/670-adding-users-and-setting-up-permissions-in-your-organization)):

    1.  Click your profile icon in the top right to confirm you are in the **R-Ladies** organization.

    2.  Click the **+ New** button in the top navigation bar and select **Invite a Team Member**.

    3.  Click **Invite a New User** and enter the curator's name and email address.

    4.  Toggle Admin Access to **No**.

    5.  Click **Invite User**.

    6.  Assign the user to the **Bluesky** channel. Under Access Level, select **Approval Required**. This will allow the user to draft posts prior to their curation week without being able to publish directly.

    7.  Click **Save 1 Change**.

7.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate whether the curator declined Buffer access or that the invite was sent and default permissions were configured.

### Sunday before they are scheduled to curate

1.  🅱️If the curator requested access to Buffer, update their access level:

    1.  Click your profile icon and select **Team**.

    2.  Use the search bar to find the curator, then click on their name.

    3.  Under the **Bluesky** channel, change their Access Level from **Approval Required** to **Full Posting Access**.

2.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that the Buffer permissions were changed, if appropriate.

3.  🦋Remove the previous curator's app password.
    1.  Go to the **Settings** page.
    2.  Select **Privacy and security**.
    3.  Select **App passwords.**
    4.  Click on the **red trash icon** next to the app password you wish to remove.
    5.  Check that the app password no longer appears in the list.

4.  🦋Generate a new app password for the upcoming curator.

    1.  Go to the **Settings** page.

    2.  Select **Privacy and security**.

    3.  Select **App passwords**.

    4.  Select **Add App Password**.

    5.  Name the app password **firstname-lastname** of the curator.

        - DO NOT SELECT "Allow access to your direct message".

    6.  Copy and paste the app password into an email to the curator:

> **_Subject: App password for the We Are R-Ladies Bluesky account_**
>
> _Hi [curator's name],_
>
> _Your curation is scheduled to start on **Monday, [start date of curation] at [11:00 AM UTC](https://www.timebie.com/std/universal.php?q=11)** and end on **Saturday, [end date of curation] at [4:00 PM UTC](https://www.timebie.com/std/universal.php?q=16)**._
>
> _Your app password to log into the We Are R-Ladies Bluesky account is **[app password]**._
>
> _Please refer to the [FAQ](https://guide.rladies.org/rocur/faq/) for instructions on how to use the app password to log into the Bluesky account._
>
> _If you haven't already, please read through our [guide](https://guide.rladies.org/rocur/guide/#curating-agreement) for our curating agreement and tips on how to engage your audience._
>
> _If you have any questions, you can email us or join the #rocur channel on the R-Ladies Community Slack where you can reach out to the RoCur admins and get connected with past curators._
>
> _Looking forward to your curation!_
>
> _Rotating Curation (RoCur) admins_

5.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that Email 3 (provision of app password) has been sent out.
6.  🦋Post their introduction graphic on Bluesky with the following message and Alt Text. You should be able to pull this information from their Airtable form submission. Ideally, this should go out **before [6:00 PM UTC](https://www.timebie.com/std/universal.php?q=18)**.

> _This week's #RLadies curator is [their Bluesky handle]._
>
> Alt text: Curator [name], [role/title] at [organization]. They say, "[what they do in R]".

7.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that their introduction has been posted on Bluesky.

### Immediately prior to curation

1.  🦋Change the avatar for the account to the photo provided by the curator.
2.  🦋In the bio of the Bluesky account, include their Bluesky handle after _"This week's curator:"_.
3.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that the account profile has been updated.

### After they curate

1.  🅱️If the curator used Buffer, remove them from the organization:
    1.  Click your profile icon and select **Team**.
    2.  Use the search bar to find the curator, then click on their name.
    3.  Click **Edit User**.
    4.  Click **Remove**.
    5.  A pop-up window will appear; follow the prompts to confirm and complete the removal.
2.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that the user has been removed from Buffer, if appropriate.
3.  🦋Replace the curator's profile photo with the We Are R-Ladies logo. The image is saved in the [root of the Google Drive](https://drive.google.com/file/d/1x_AaAM_3qYvCqE4yhC6fNcLvlcGjRqdC/view?usp=drive_link).
4.  🦋Change the last line of the bio of the Bluesky account to *"This week's curator: TBA"*.
5.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that the account has been reverted to its default state.
6.  Add the curator to the We Are R-Ladies starter pack.
7.  ✉️Send a thank you email to the curator. You can use the sample below:

> **_Subject: Thank you for contributing to the We Are R-Ladies Bluesky account!_**
>
> _Hi [curator's name]:_
>
> _Thank you so much for curating the We Are R-Ladies Bluesky account! We truly appreciate your time and effort to engage the broader R community and highlight minority genders and their great work in R._
>
> *Now that your curation is finished, please remember to sign out of the We Are R-Ladies Bluesky account.*
>
> _Your feedback is important to us and is essential to the continued improvement of the rotating curation program. What went well? What could be improved? What went badly? We welcome direct feedback to this email._
>
> _If you write about your curating week and would like us to incorporate it into the guide, please either submit a pull request or notify us so that we can do that for you._
>
> _Lastly, please consider nominating fellow R-Ladies to curate using [the nomination form](https://airtable.com/appFIBzsk2AxWlGMt/pagfezjuCxohikOOa/form). We value hearing diverse voices from R-Ladies around the world, and we greatly appreciate your assistance in identifying R-Ladies whose work you admire._
>
> _We thank you for your service to the R-Ladies community!_
>
> _Rotating Curation (RoCur) admins_

8.  📊Update the admin checklist in the RoCur Curator Sign Up Airtable to indicate that Email 4 (thank-yous) has been sent out.

## Other Information on Infrastructure & Procedures

In addition to the Bluesky account, other means of communication that RoCur admins have access to are:

- RoCur email address: [weare\@rladies.org](mailto:weare@rladies.org)

- #rocur channel on the [R-Ladies Community Slack](https://rladies.org/form/community-slack/)

Additionally, admin members will have access to Airtable and shared Google Drive folders.
